/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.debugger.jpda.projects.ClassToInvoke;
import org.netbeans.modules.debugger.jpda.projects.CodeCompiler;
import org.netbeans.modules.debugger.jpda.projects.IntroduceClass;
import org.openide.filesystems.FileObject;

class CodeSnippetCompiler {
    private static final String INVOCATION_CLASS_NAME = "OrgNetBeansDebuggerInvocationInnerClass";
    private static final AtomicLong LAST_CLASS_ID = new AtomicLong(0L);

    CodeSnippetCompiler() {
    }

    static ClassToInvoke compileToClass(CompilationInfo ci, String code, int codeOffset, JavaSource js, FileObject fo, int line, TreePath treePath, Tree tree, boolean staticContext) throws InvalidExpressionException {
        Map<String, byte[]> compiledClass;
        TreePathHandle tph = TreePathHandle.create((TreePath)treePath, (CompilationInfo)ci);
        String className = INVOCATION_CLASS_NAME + LAST_CLASS_ID.incrementAndGet();
        IntroduceClass introClass = new IntroduceClass(code, codeOffset, staticContext);
        boolean success = introClass.computeIntroduceMethod(tph, ci, treePath, tree);
        if (!success) {
            return null;
        }
        String methodInvoke = introClass.getMethodInvoke();
        try {
            String fullCode = introClass.computeIntroduceClass(className, fo);
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            compiledClass = CodeCompiler.compile(fo, js, fullCode, diagnostics);
            if (compiledClass == null) {
                return null;
            }
            for (Diagnostic diag : diagnostics.getDiagnostics()) {
                if (Diagnostic.Kind.ERROR != diag.getKind() || diag.getSource() == null || !((JavaFileObject)diag.getSource()).isNameCompatible(className, JavaFileObject.Kind.CLASS)) continue;
                throw new InvalidExpressionException(diag.getMessage(null));
            }
        }
        catch (IOException ioe) {
            throw new InvalidExpressionException((Throwable)ioe);
        }
        String classFQN = null;
        LinkedHashMap<String, byte[]> innerClasses = null;
        for (String ccName : compiledClass.keySet()) {
            if (ccName.endsWith(className)) {
                classFQN = ccName;
                continue;
            }
            if (!ccName.contains(className)) continue;
            if (innerClasses == null) {
                innerClasses = new LinkedHashMap<String, byte[]>();
            }
            innerClasses.put(ccName, compiledClass.get(ccName));
        }
        if (classFQN == null) {
            return null;
        }
        return new ClassToInvoke(classFQN, compiledClass.get(classFQN), "new " + className + "()." + methodInvoke, innerClasses);
    }
}

