/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.util.Collections;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.html.editor.HtmlSourceUtils;
import org.netbeans.modules.html.editor.hints.css.Bundle;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public class AddStylesheetLinkHintFix
implements HintFix {
    private final FileObject externalStylesheet;
    private final FileObject sourceFile;
    private final String path;

    public AddStylesheetLinkHintFix(FileObject sourceFile, FileObject externalStylesheet) {
        this.sourceFile = sourceFile;
        this.externalStylesheet = externalStylesheet;
        this.path = WebUtils.getRelativePath((FileObject)sourceFile, (FileObject)externalStylesheet);
    }

    public String getDescription() {
        return Bundle.description_add_stylesheet_reference(this.path);
    }

    public void implement() throws Exception {
        Source source = Source.create((FileObject)this.sourceFile);
        Document doc = source.getDocument(false);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                Parser.Result result = resultIterator.getParserResult();
                if (!(result instanceof HtmlParsingResult)) {
                    return;
                }
                ModificationResult modification = new ModificationResult();
                if (HtmlSourceUtils.importStyleSheet(modification, (HtmlParsingResult)result, result.getSnapshot(), AddStylesheetLinkHintFix.this.externalStylesheet)) {
                    modification.commit();
                }
            }
        });
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

