/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.Color;
import java.io.File;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.modules.git.Bundle;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.util.common.VCSFileNode;

public abstract class GitFileNode<T extends FileNodeInformation>
extends VCSFileNode {
    protected GitFileNode(File root, File file) {
        super(root, file);
    }

    public abstract T getInformation();

    public static abstract class FileNodeInformation
    extends VCSFileInformation {
        public abstract boolean isCopied();

        public abstract boolean isRenamed();

        public abstract File getOldFile();
    }

    public static class HistoryFileInformation
    extends FileNodeInformation {
        private final GitRevisionInfo.GitFileInfo info;

        public HistoryFileInformation(GitRevisionInfo.GitFileInfo info) {
            this.info = info;
        }

        @Override
        public boolean isCopied() {
            return this.info.getStatus() == GitRevisionInfo.GitFileInfo.Status.COPIED;
        }

        @Override
        public boolean isRenamed() {
            return this.info.getStatus() == GitRevisionInfo.GitFileInfo.Status.RENAMED;
        }

        @Override
        public File getOldFile() {
            return this.info.getOriginalFile();
        }

        public String getOldPath() {
            return this.info.getOriginalPath();
        }

        public String getStatusText() {
            switch (this.info.getStatus()) {
                case ADDED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Added();
                }
                case COPIED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Copied();
                }
                case MODIFIED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Modified();
                }
                case REMOVED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Removed();
                }
                case RENAMED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Renamed();
                }
            }
            return Bundle.CTL_HistoryFileInfo_Status_Unknown();
        }

        public int getComparableStatus() {
            return GitRevisionInfo.GitFileInfo.Status.values().length - this.info.getStatus().ordinal();
        }

        public String annotateNameHtml(String name) {
            return (switch (this.info.getStatus()) {
                case GitRevisionInfo.GitFileInfo.Status.ADDED -> AnnotationColorProvider.getInstance().ADDED_FILE;
                case GitRevisionInfo.GitFileInfo.Status.COPIED -> AnnotationColorProvider.getInstance().ADDED_FILE;
                case GitRevisionInfo.GitFileInfo.Status.MODIFIED -> AnnotationColorProvider.getInstance().MODIFIED_FILE;
                case GitRevisionInfo.GitFileInfo.Status.REMOVED -> AnnotationColorProvider.getInstance().REMOVED_FILE;
                case GitRevisionInfo.GitFileInfo.Status.RENAMED -> AnnotationColorProvider.getInstance().ADDED_FILE;
                default -> AnnotationColorProvider.getInstance().EXCLUDED_FILE;
            }).getFormat().format(new Object[]{name, ""});
        }

        public Color getAnnotatedColor() {
            switch (this.info.getStatus()) {
                case ADDED: {
                    return AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor();
                }
                case COPIED: {
                    return AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor();
                }
                case MODIFIED: {
                    return AnnotationColorProvider.getInstance().MODIFIED_FILE.getActualColor();
                }
                case REMOVED: {
                    return AnnotationColorProvider.getInstance().REMOVED_FILE.getActualColor();
                }
                case RENAMED: {
                    return AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor();
                }
            }
            return AnnotationColorProvider.getInstance().EXCLUDED_FILE.getActualColor();
        }
    }

    public static class GitHistoryFileNode
    extends GitFileNode<HistoryFileInformation> {
        private final HistoryFileInformation fi;

        public GitHistoryFileNode(File root, File file, HistoryFileInformation info) {
            super(root, file);
            this.fi = info;
        }

        @Override
        public HistoryFileInformation getInformation() {
            return this.fi;
        }

        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            return VCSCommitOptions.EXCLUDE;
        }
    }

    public static class GitMergeFileNode
    extends GitLocalFileNode {
        private FileInformation.Mode mode;

        public GitMergeFileNode(File root, File file, FileInformation.Mode mode) {
            super(root, file);
            this.mode = mode;
        }

        @Override
        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            if (this.getInformation().containsStatus(FileInformation.STATUS_REMOVED)) {
                return VCSCommitOptions.COMMIT_REMOVE;
            }
            if (this.getInformation().containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE) && !this.getInformation().containsStatus(FileInformation.Status.REMOVED_HEAD_INDEX)) {
                return VCSCommitOptions.EXCLUDE;
            }
            return VCSCommitOptions.COMMIT;
        }
    }

    public static class GitLocalFileNode
    extends GitFileNode<FileInformation> {
        private FileInformation.Mode mode;

        public GitLocalFileNode(File root, File file) {
            super(root, file);
        }

        public GitLocalFileNode(File root, File file, FileInformation.Mode mode) {
            super(root, file);
            this.mode = mode;
        }

        @Override
        public FileInformation getInformation() {
            return Git.getInstance().getFileStatusCache().getStatus(this.getFile());
        }

        public String getStatusText() {
            return this.mode == null ? this.getInformation().getStatusText() : this.getInformation().getStatusText(this.mode);
        }

        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            if (withExclusions && GitModuleConfig.getDefault().isExcludedFromCommit(this.getFile().getAbsolutePath())) {
                return VCSCommitOptions.EXCLUDE;
            }
            if (this.getInformation().containsStatus(FileInformation.STATUS_REMOVED)) {
                return VCSCommitOptions.COMMIT_REMOVE;
            }
            if (this.getInformation().containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
                return withExclusions && GitModuleConfig.getDefault().getExludeNewFiles() ? VCSCommitOptions.EXCLUDE : VCSCommitOptions.COMMIT;
            }
            return VCSCommitOptions.COMMIT;
        }
    }
}

