/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;
import org.graalvm.visualvm.core.options.UISupport;
import org.graalvm.visualvm.core.properties.PropertiesPanel;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.jmx.CredentialsProvider;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.jmx.JmxConnectionCustomizer;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxApplicationProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DefaultCustomizer
extends JmxConnectionCustomizer {
    private static final String PROP_CONNECT_IMMEDIATELY = "DefaultJMXCustomizer_prop_connect_immediately";
    private static final String PROP_CONNECT_AUTOMATICALLY = "DefaultJMXCustomizer_prop_connect_automatically";
    private static final boolean DEFAULT_CONNECT_IMMEDIATELY = true;
    private static final boolean DEFAULT_CONNECT_AUTOMATICALLY = true;

    DefaultCustomizer() {
        super(NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Default_jmx_connection_name"), NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Default_jmx_connection_descr"), 1, false);
    }

    @Override
    public boolean providesProperties(Application application) {
        if (!(application instanceof JmxApplication)) {
            return false;
        }
        EnvironmentProvider provider = ((JmxApplication)application).getEnvironmentProvider();
        return provider instanceof CredentialsProvider;
    }

    public PropertiesPanel createPanel(Application application) {
        if (application == null) {
            return new CustomizerUI();
        }
        return new PropertiesUI(application);
    }

    @Override
    public JmxConnectionCustomizer.Setup getConnectionSetup(PropertiesPanel customizerPanel) {
        if (!(customizerPanel instanceof CustomizerUI)) {
            throw new IllegalArgumentException("Panel must be DefaultCustomizer.CustomizerUI");
        }
        CustomizerUI panel = (CustomizerUI)customizerPanel;
        String connectionString = panel.getConnectionString();
        String displayName = panel.getDisplayName();
        CredentialsProvider.Custom provider = new CredentialsProvider.Custom(panel.getUsername(), panel.getPassword(), panel.getSaveCredentials());
        boolean persistent = true;
        boolean allowInsecure = panel.allowsInsecureConnection();
        boolean connectImmediately = panel.isConnectImmediately();
        NbPreferences.forModule(DefaultCustomizer.class).putBoolean(PROP_CONNECT_IMMEDIATELY, connectImmediately);
        boolean autoConnect = panel.isConnectAutomatically();
        NbPreferences.forModule(DefaultCustomizer.class).putBoolean(PROP_CONNECT_AUTOMATICALLY, autoConnect);
        return new JmxConnectionCustomizer.Setup(connectionString, displayName, provider, persistent, allowInsecure, connectImmediately, autoConnect);
    }

    protected static boolean isValidConnectionString(String jmxurl) {
        boolean valid = false;
        if (jmxurl != null) {
            if ((jmxurl = jmxurl.trim()).startsWith("service:jmx:")) {
                if (jmxurl.length() > "service:jmx:".length()) {
                    valid = true;
                }
            } else {
                try {
                    new URL("http://" + jmxurl);
                }
                catch (MalformedURLException ex) {
                    return false;
                }
                if (jmxurl.startsWith("[")) {
                    int index = jmxurl.indexOf("]:");
                    if (index != -1) {
                        try {
                            String portStr = jmxurl.substring(index + 2);
                            int port = Integer.parseInt(portStr);
                            if (port >= 0 && port <= 65535) {
                                valid = true;
                            }
                        }
                        catch (NumberFormatException ex) {
                            valid = false;
                        }
                    }
                } else {
                    String[] s = jmxurl.split(":");
                    if (s.length == 2) {
                        try {
                            int port = Integer.parseInt(s[1]);
                            if (port >= 0 && port <= 65535) {
                                valid = true;
                            }
                        }
                        catch (NumberFormatException ex) {
                            valid = false;
                        }
                    }
                }
            }
        }
        return valid;
    }

    public static class PropertiesUI
    extends PropertiesPanel {
        private JLabel connectionLabel;
        private JTextField connectionField;
        private JCheckBox securityCheckbox;
        private JLabel usernameLabel;
        private JTextField usernameField;
        private JLabel passwordLabel;
        private JPasswordField passwordField;
        private JCheckBox saveCheckbox;
        private JCheckBox noSSLCheckbox;

        public PropertiesUI(Application application) {
            this.initComponents();
            this.setValues(application);
        }

        private void setValues(Application application) {
            JmxApplication app = (JmxApplication)application;
            String connectionString = JmxApplicationProvider.getConnectionString(app);
            Storage storage = application.getStorage();
            CredentialsProvider provider = (CredentialsProvider)app.getEnvironmentProvider();
            String username = provider.getUsername(storage);
            boolean isusername = username != null && !username.isEmpty();
            boolean ispassword = provider.hasPassword(storage);
            boolean ispersistent = provider.isPersistent(storage);
            String noSSL = storage.getCustomProperty("prop_retry_without_ssl");
            this.connectionField.setText(connectionString);
            this.connectionField.setCaretPosition(0);
            this.securityCheckbox.setSelected(isusername || ispassword);
            this.usernameField.setText(username);
            this.usernameField.setCaretPosition(0);
            this.passwordField.setText(ispassword ? "----------" : "");
            this.passwordField.setCaretPosition(0);
            this.saveCheckbox.setSelected(ispersistent);
            this.noSSLCheckbox.setSelected(noSSL != null && Boolean.parseBoolean(noSSL));
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            Color checkboxForeground = UIManager.getColor("CheckBox.foreground");
            Color checkboxText = new Color(checkboxForeground.getRGB());
            this.connectionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Connection"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 0, 3, 0);
            this.add(this.connectionLabel, constraints);
            this.connectionField = new JTextField();
            this.connectionLabel.setLabelFor(this.connectionField);
            this.connectionField.setEditable(false);
            Dimension size = this.connectionField.getPreferredSize();
            size.width = 1;
            this.connectionField.setPreferredSize(size);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(3, 5, 3, 0);
            this.add(this.connectionField, constraints);
            this.securityCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.securityCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Use_security_credentials"));
            this.securityCheckbox.setEnabled(false);
            this.securityCheckbox.setOpaque(false);
            this.securityCheckbox.setForeground(checkboxText);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(15, 0, 0, 0);
            this.add(this.securityCheckbox, constraints);
            this.usernameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Username"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 20, 0, 0);
            this.add(this.usernameLabel, constraints);
            this.usernameField = new JTextField();
            this.usernameLabel.setLabelFor(this.usernameField);
            this.usernameField.setEditable(false);
            size = this.usernameField.getPreferredSize();
            size.width = 1;
            this.usernameField.setPreferredSize(size);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 4;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 5, 0, 0);
            this.add(this.usernameField, constraints);
            this.passwordLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Password"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 20, 0, 0);
            this.add(this.passwordLabel, constraints);
            this.passwordField = new JPasswordField();
            this.passwordLabel.setLabelFor(this.passwordField);
            this.passwordField.setEditable(false);
            this.passwordField.setFocusable(false);
            size = this.passwordField.getPreferredSize();
            size.width = 1;
            this.passwordField.setPreferredSize(size);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 5;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 5, 0, 0);
            this.add(this.passwordField, constraints);
            this.saveCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.saveCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Save_security_credentials"));
            this.saveCheckbox.setEnabled(false);
            this.saveCheckbox.setOpaque(false);
            this.saveCheckbox.setForeground(checkboxText);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 6;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 16, 0, 0);
            this.add(this.saveCheckbox, constraints);
            this.noSSLCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.noSSLCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Insecure_connection"));
            this.noSSLCheckbox.setEnabled(false);
            this.noSSLCheckbox.setOpaque(false);
            this.noSSLCheckbox.setForeground(checkboxText);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 7;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(15, 0, 3, 0);
            this.add(this.noSSLCheckbox, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 8;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)Spacer.create(), constraints);
            Border b = this.connectionLabel.getBorder();
            int r = b == null ? 0 : b.getBorderInsets((Component)this.connectionLabel).right;
            Border c = this.securityCheckbox.getBorder();
            if (c != null) {
                Insets i = c.getBorderInsets(this.securityCheckbox);
                if (i == null) {
                    i = new Insets(0, 0, 0, 0);
                }
                Border bb = BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, r);
                this.securityCheckbox.setBorder(bb);
                this.noSSLCheckbox.setBorder(bb);
            }
        }
    }

    public static class CustomizerUI
    extends PropertiesPanel {
        private boolean internalChange = false;
        private JLabel connectionLabel;
        private JTextField connectionField;
        private JLabel usageLabel;
        private JCheckBox displaynameCheckbox;
        private JTextField displaynameField;
        private JCheckBox securityCheckbox;
        private JLabel usernameLabel;
        private JTextField usernameField;
        private JLabel passwordLabel;
        private JPasswordField passwordField;
        private JCheckBox saveCheckbox;
        private JCheckBox noSSLCheckbox;
        private JCheckBox connectImmediatelyChoice;
        private JCheckBox autoConnectChoice;

        public CustomizerUI() {
            this.initComponents();
            this.initDefaults();
            this.update();
        }

        public final String getConnectionString() {
            return this.connectionField.getText().trim();
        }

        public final String getDisplayName() {
            return !this.displaynameCheckbox.isSelected() ? null : this.displaynameField.getText().trim();
        }

        public final String getUsername() {
            return !this.securityCheckbox.isSelected() ? null : this.usernameField.getText().trim();
        }

        public final char[] getPassword() {
            return !this.securityCheckbox.isSelected() ? null : this.passwordField.getPassword();
        }

        public final boolean getSaveCredentials() {
            return !this.securityCheckbox.isSelected() ? false : this.saveCheckbox.isSelected();
        }

        public final boolean allowsInsecureConnection() {
            return this.noSSLCheckbox.isSelected();
        }

        public final boolean isConnectImmediately() {
            return this.connectImmediatelyChoice.isSelected();
        }

        public final boolean isConnectAutomatically() {
            return this.autoConnectChoice.isSelected();
        }

        private void initDefaults() {
            Set selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
            if (selectedDataSources.size() != 1) {
                return;
            }
            DataSource selectedDataSource = (DataSource)selectedDataSources.iterator().next();
            if (!(selectedDataSource instanceof Host)) {
                return;
            }
            Host host = (Host)selectedDataSource;
            this.connectionField.setText(host.getHostName() + ":");
        }

        private void update() {
            if (this.internalChange) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String username = this.getUsername();
                    String url = this.getConnectionString();
                    if (!displaynameCheckbox.isSelected()) {
                        internalChange = true;
                        displaynameField.setText((username == null || username.isEmpty() ? "" : username + "@") + url);
                        internalChange = false;
                    }
                    String displayname = this.getDisplayName();
                    displaynameField.setEnabled(displaynameCheckbox.isSelected());
                    usernameField.setEnabled(securityCheckbox.isSelected());
                    passwordField.setEnabled(securityCheckbox.isSelected());
                    saveCheckbox.setEnabled(securityCheckbox.isSelected());
                    this.setSettingsValid(DefaultCustomizer.isValidConnectionString(url) && (!displaynameCheckbox.isSelected() || !displayname.isEmpty()));
                }
            });
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.connectionLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Connection"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add(this.connectionLabel, constraints);
            this.connectionField = new JTextField();
            this.connectionLabel.setLabelFor(this.connectionField);
            this.connectionField.setPreferredSize(new Dimension(250, this.connectionField.getPreferredSize().height));
            this.connectionField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add(this.connectionField, constraints);
            Font normalLabelFont = this.connectionLabel.getFont();
            Font smallLabelFont = normalLabelFont.deriveFont(normalLabelFont.getSize2D() - 1.0f);
            this.usageLabel = new JLabel(NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Usage"));
            this.usageLabel.setFont(smallLabelFont);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add(this.usageLabel, constraints);
            this.displaynameCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Display_name"));
            this.displaynameCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(this.displaynameCheckbox, constraints);
            this.displaynameField = new JTextField();
            this.displaynameField.setPreferredSize(new Dimension(250, this.displaynameField.getPreferredSize().height));
            this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 5, 0, 0);
            this.add(this.displaynameField, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(20, 0, 0, 0);
            this.add((Component)UISupport.createSectionSeparator((String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Caption_Security")), constraints);
            this.securityCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.securityCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Use_security_credentials"));
            this.securityCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(this.securityCheckbox, constraints);
            this.usernameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Username"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add(this.usernameLabel, constraints);
            this.usernameField = new JTextField();
            this.usernameLabel.setLabelFor(this.usernameField);
            this.usernameField.setPreferredSize(new Dimension(320, this.usernameField.getPreferredSize().height));
            this.usernameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 5;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 5, 0, 0);
            this.add(this.usernameField, constraints);
            this.passwordLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Password"));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 6;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(this.passwordLabel, constraints);
            this.passwordField = new JPasswordField();
            this.passwordLabel.setLabelFor(this.passwordField);
            this.passwordField.setPreferredSize(new Dimension(200, this.passwordField.getPreferredSize().height));
            this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 6;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 5, 0, 0);
            this.add(this.passwordField, constraints);
            this.saveCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.saveCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Save_security_credentials"));
            this.saveCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 7;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 13;
            constraints.insets = new Insets(8, 30, 0, 0);
            this.add(this.saveCheckbox, constraints);
            this.noSSLCheckbox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.noSSLCheckbox, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Insecure_connection"));
            this.noSSLCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 8;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(15, 0, 0, 0);
            this.add(this.noSSLCheckbox, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 9;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(20, 0, 0, 0);
            this.add((Component)UISupport.createSectionSeparator((String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Caption_Connection")), constraints);
            JPanel connectOptions = new JPanel(null);
            connectOptions.setLayout(new BoxLayout(connectOptions, 2));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 10;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(connectOptions, constraints);
            this.connectImmediatelyChoice = new JCheckBox(){

                @Override
                protected void fireItemStateChanged(ItemEvent e) {
                    super.fireItemStateChanged(e);
                    if (autoConnectChoice != null) {
                        autoConnectChoice.setEnabled(this.isSelected());
                    }
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.connectImmediatelyChoice, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Connect_Immediately"));
            this.connectImmediatelyChoice.setToolTipText(NbBundle.getMessage(DefaultCustomizer.class, (String)"TTP_Connect_Immediately"));
            connectOptions.add(this.connectImmediatelyChoice);
            connectOptions.add(Box.createHorizontalStrut(8));
            this.autoConnectChoice = new JCheckBox(){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    if (!enabled) {
                        this.setSelected(false);
                    }
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.autoConnectChoice, (String)NbBundle.getMessage(DefaultCustomizer.class, (String)"LBL_Auto_Connect"));
            this.autoConnectChoice.setToolTipText(NbBundle.getMessage(DefaultCustomizer.class, (String)"TTP_Auto_Connect"));
            connectOptions.add(this.autoConnectChoice);
            this.connectImmediatelyChoice.setSelected(NbPreferences.forModule(DefaultCustomizer.class).getBoolean(DefaultCustomizer.PROP_CONNECT_IMMEDIATELY, true));
            if (this.connectImmediatelyChoice.isSelected()) {
                this.autoConnectChoice.setSelected(NbPreferences.forModule(DefaultCustomizer.class).getBoolean(DefaultCustomizer.PROP_CONNECT_AUTOMATICALLY, true));
            } else {
                this.autoConnectChoice.setEnabled(false);
            }
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 11;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)Spacer.create(), constraints);
            Border b = this.connectionLabel.getBorder();
            int r = b == null ? 0 : b.getBorderInsets((Component)this.connectionLabel).right;
            Border c = this.displaynameCheckbox.getBorder();
            if (c != null) {
                Insets i = c.getBorderInsets(this.displaynameCheckbox);
                if (i == null) {
                    i = new Insets(0, 0, 0, 0);
                }
                Border bb = BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, r);
                this.displaynameCheckbox.setBorder(bb);
                this.securityCheckbox.setBorder(bb);
                this.noSSLCheckbox.setBorder(bb);
            }
        }
    }
}

