// @generated
// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4Data {
    #[prost(oneof="p4_data::Data", tags="1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12")]
    pub data: ::core::option::Option<p4_data::Data>,
}
/// Nested message and enum types in `P4Data`.
pub mod p4_data {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Data {
        /// for bit<W>, int<W>
        #[prost(bytes, tag="1")]
        Bitstring(::prost::alloc::vec::Vec<u8>),
        /// for varbit<W>
        #[prost(message, tag="2")]
        Varbit(super::P4Varbit),
        #[prost(bool, tag="3")]
        Bool(bool),
        #[prost(message, tag="4")]
        Tuple(super::P4StructLike),
        #[prost(message, tag="5")]
        Struct(super::P4StructLike),
        #[prost(message, tag="6")]
        Header(super::P4Header),
        #[prost(message, tag="7")]
        HeaderUnion(super::P4HeaderUnion),
        #[prost(message, tag="8")]
        HeaderStack(super::P4HeaderStack),
        #[prost(message, tag="9")]
        HeaderUnionStack(super::P4HeaderUnionStack),
        /// safe (non-serializable) enums only
        #[prost(string, tag="10")]
        Enum(::prost::alloc::string::String),
        #[prost(string, tag="11")]
        Error(::prost::alloc::string::String),
        /// serializable enums only
        #[prost(bytes, tag="12")]
        EnumValue(::prost::alloc::vec::Vec<u8>),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4Varbit {
    #[prost(bytes="vec", tag="1")]
    pub bitstring: ::prost::alloc::vec::Vec<u8>,
    /// dynamic bitwidth of the field
    #[prost(int32, tag="2")]
    pub bitwidth: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4StructLike {
    #[prost(message, repeated, tag="1")]
    pub members: ::prost::alloc::vec::Vec<P4Data>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4Header {
    /// If the header is invalid (is_valid is "false"), then the bitstrings
    /// repeated field must be empty.
    #[prost(bool, tag="1")]
    pub is_valid: bool,
    #[prost(bytes="vec", repeated, tag="2")]
    pub bitstrings: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderUnion {
    /// An empty string indicates that none of the union members are valid and
    /// valid_header must therefore be unset.
    #[prost(string, tag="1")]
    pub valid_header_name: ::prost::alloc::string::String,
    #[prost(message, optional, tag="2")]
    pub valid_header: ::core::option::Option<P4Header>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderStack {
    /// The length of this repeated field must always be equal to the compile-time
    /// size of the header stack, which is specified in P4Info.
    #[prost(message, repeated, tag="1")]
    pub entries: ::prost::alloc::vec::Vec<P4Header>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct P4HeaderUnionStack {
    /// The length of this repeated field must always be equal to the compile-time
    /// size of the header union stack, which is specified in P4Info.
    #[prost(message, repeated, tag="1")]
    pub entries: ::prost::alloc::vec::Vec<P4HeaderUnion>,
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriteRequest {
    #[prost(uint64, tag="1")]
    pub device_id: u64,
    /// Deprecated in v1.4.0
    #[deprecated]
    #[prost(uint64, tag="2")]
    pub role_id: u64,
    /// Added in v1.4.0
    #[prost(string, tag="6")]
    pub role: ::prost::alloc::string::String,
    #[prost(message, optional, tag="3")]
    pub election_id: ::core::option::Option<Uint128>,
    /// The write batch, comprising a list of Update operations. The P4Runtime
    /// server may arbitrarily reorder messages within a batch to maximize
    /// performance.
    #[prost(message, repeated, tag="4")]
    pub updates: ::prost::alloc::vec::Vec<Update>,
    #[prost(enumeration="write_request::Atomicity", tag="5")]
    pub atomicity: i32,
}
/// Nested message and enum types in `WriteRequest`.
pub mod write_request {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Atomicity {
        /// Required. This is the default behavior. The batch is processed in a
        /// non-atomic manner from a data plane point of view. Each operation within
        /// the batch must be attempted even if one or more encounter errors.
        /// Every data plane packet is guaranteed to be processed according to
        /// table contents as they are between two individual operations of the
        /// batch, but there could be several packets processed that see each of
        /// these intermediate stages.
        ContinueOnError = 0,
        /// Optional. Operations within the batch are committed to data plane until
        /// an error is encountered. At this point, the operations must be rolled
        /// back such that both software and data plane state is consistent with the
        /// state before the batch was attempted. The resulting behavior is
        /// all-or-none, except the batch is not atomic from a data plane point of
        /// view. Every data plane packet is guaranteed to be processed according to
        /// table contents as they are between two individual operations of the
        /// batch, but there could be several packets processed that see each of
        /// these intermediate stages.
        RollbackOnError = 1,
        /// Optional. Every data plane packet is guaranteed to be processed according
        /// to table contents before the batch began, or after the batch completed
        /// and the operations were programmed to the hardware.
        /// The batch is therefore treated as a transaction.
        DataplaneAtomic = 2,
    }
    impl Atomicity {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Atomicity::ContinueOnError => "CONTINUE_ON_ERROR",
                Atomicity::RollbackOnError => "ROLLBACK_ON_ERROR",
                Atomicity::DataplaneAtomic => "DATAPLANE_ATOMIC",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CONTINUE_ON_ERROR" => Some(Self::ContinueOnError),
                "ROLLBACK_ON_ERROR" => Some(Self::RollbackOnError),
                "DATAPLANE_ATOMIC" => Some(Self::DataplaneAtomic),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct WriteResponse {
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReadRequest {
    #[prost(uint64, tag="1")]
    pub device_id: u64,
    /// When specified, only return table entries for the given role.
    /// Added in 1.4.0.
    #[prost(string, tag="3")]
    pub role: ::prost::alloc::string::String,
    #[prost(message, repeated, tag="2")]
    pub entities: ::prost::alloc::vec::Vec<Entity>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReadResponse {
    #[prost(message, repeated, tag="1")]
    pub entities: ::prost::alloc::vec::Vec<Entity>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Update {
    #[prost(enumeration="update::Type", tag="1")]
    pub r#type: i32,
    #[prost(message, optional, tag="2")]
    pub entity: ::core::option::Option<Entity>,
}
/// Nested message and enum types in `Update`.
pub mod update {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Type {
        Unspecified = 0,
        Insert = 1,
        Modify = 2,
        Delete = 3,
    }
    impl Type {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Type::Unspecified => "UNSPECIFIED",
                Type::Insert => "INSERT",
                Type::Modify => "MODIFY",
                Type::Delete => "DELETE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSPECIFIED" => Some(Self::Unspecified),
                "INSERT" => Some(Self::Insert),
                "MODIFY" => Some(Self::Modify),
                "DELETE" => Some(Self::Delete),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Entity {
    #[prost(oneof="entity::Entity", tags="1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12")]
    pub entity: ::core::option::Option<entity::Entity>,
}
/// Nested message and enum types in `Entity`.
pub mod entity {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Entity {
        #[prost(message, tag="1")]
        ExternEntry(super::ExternEntry),
        #[prost(message, tag="2")]
        TableEntry(super::TableEntry),
        #[prost(message, tag="3")]
        ActionProfileMember(super::ActionProfileMember),
        #[prost(message, tag="4")]
        ActionProfileGroup(super::ActionProfileGroup),
        #[prost(message, tag="5")]
        MeterEntry(super::MeterEntry),
        #[prost(message, tag="6")]
        DirectMeterEntry(super::DirectMeterEntry),
        #[prost(message, tag="7")]
        CounterEntry(super::CounterEntry),
        #[prost(message, tag="8")]
        DirectCounterEntry(super::DirectCounterEntry),
        #[prost(message, tag="9")]
        PacketReplicationEngineEntry(super::PacketReplicationEngineEntry),
        #[prost(message, tag="10")]
        ValueSetEntry(super::ValueSetEntry),
        #[prost(message, tag="11")]
        RegisterEntry(super::RegisterEntry),
        #[prost(message, tag="12")]
        DigestEntry(super::DigestEntry),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExternEntry {
    /// the extern_type_id is unique for a given architecture and must be in the
    /// range \[0x81, 0xfe\].
    #[prost(uint32, tag="1")]
    pub extern_type_id: u32,
    /// id of the instance
    #[prost(uint32, tag="2")]
    pub extern_id: u32,
    #[prost(message, optional, tag="3")]
    pub entry: ::core::option::Option<::pbjson_types::Any>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableEntry {
    #[prost(uint32, tag="1")]
    pub table_id: u32,
    #[prost(message, repeated, tag="2")]
    pub r#match: ::prost::alloc::vec::Vec<FieldMatch>,
    #[prost(message, optional, tag="3")]
    pub action: ::core::option::Option<TableAction>,
    /// Should only be set if the match implies a TCAM lookup, i.e. at least one of
    /// the match fields is Optional, Ternary or Range.  A higher number indicates
    /// higher priority.  Only a highest priority entry that matches the packet
    /// must be selected.  Multiple entries in the same table with the same
    /// priority value are permitted.  See Section "TableEntry" in the
    /// specification for details of the behavior.
    #[prost(int32, tag="4")]
    pub priority: i32,
    /// Metadata (cookie) opaque to the target. There is no requirement of where
    /// this is stored, as long as it is returned with the rest of the entry in
    /// a Read RPC. This is deprecated in favor of the more flexible metadata
    /// field.
    #[deprecated]
    #[prost(uint64, tag="5")]
    pub controller_metadata: u64,
    /// meter_config, counter_data and meter_counter_data are convenience fields
    /// that enable the controller to configure the direct resources associated
    /// with the table at the same time as a match-action entry is inserted or
    /// modified.
    /// Table write:
    ///    - If the table does not contain a direct resource, then setting the
    ///      corresponding direct resource field in any table write operation will
    ///      return an error.
    ///    - When inserting a new table entry, leaving these fields unset means that
    ///      the direct resources of this table (if any) will assume default values.
    ///      For counters, the default value is 0, and for meters, the default value
    ///      is always green.
    ///    - When updating a table entry, leaving meter_config unset will reset the
    ///      meter (if any) to its default configuration, while leaving counter_data
    ///      or meter_counter_data unset means that the counter (if any) will not be
    ///      updated.
    /// Table read:
    ///    - If the table does not contain a direct resource, then the corresponding
    ///      field will not be set in the read table entry.
    ///    - If meter_config is unset in the request, or if the meter has a default
    ///      configuration, meter_config will not be set in the response.
    ///    - If counter_data or meter_counter_data is unset in the request, it will
    ///      be unset in the response as well.
    #[prost(message, optional, tag="6")]
    pub meter_config: ::core::option::Option<MeterConfig>,
    #[prost(message, optional, tag="7")]
    pub counter_data: ::core::option::Option<CounterData>,
    /// Per color counters for tables with a direct meter.
    /// Added in v1.4.0
    #[prost(message, optional, tag="12")]
    pub meter_counter_data: ::core::option::Option<MeterCounterData>,
    /// Set to true if the table entry is being used to update the non-const
    /// default action of the table. If true, the "match" field must be empty and
    /// the "action" field must be populated with a valid direct action.
    #[prost(bool, tag="8")]
    pub is_default_action: bool,
    /// The TTL for the entry, in nanoseconds. A value of 0 means that the table
    /// entry never "expires".
    #[prost(int64, tag="9")]
    pub idle_timeout_ns: i64,
    /// Table write: this field should be left unset.
    /// Table read: if the table supports idle timeout and time_since_last_hit is
    /// set in the request, this field will be set in the response.
    #[prost(message, optional, tag="10")]
    pub time_since_last_hit: ::core::option::Option<table_entry::IdleTimeout>,
    /// Arbitrary metadata from the controller that is opaque to the target.
    #[prost(bytes="vec", tag="11")]
    pub metadata: ::prost::alloc::vec::Vec<u8>,
    /// True if and only if the entry cannot be deleted or modified,
    /// i.e. any of the following:
    /// + Any entry read from a table declared with `const entries`
    /// + The default entry read from a table declared with `const
    ///    default_action`
    /// + Any entry declared with `entries` without the `const` qualifier
    ///    before `entries`, where the individual entry has the `const`
    ///    qualifier on it in the P4 source code.
    /// Note: Older P4Runtime API servers before the `is_const` field was
    /// added to this message will not return a value for `is_const` in
    /// the first two cases above, but newer P4Runtime API servers will.
    /// Added in 1.4.0.
    #[prost(bool, tag="13")]
    pub is_const: bool,
}
/// Nested message and enum types in `TableEntry`.
pub mod table_entry {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct IdleTimeout {
        /// Time elapsed - in nanoseconds - since the table entry was last "hit" as
        /// part of a data plane table lookup.
        #[prost(int64, tag="1")]
        pub elapsed_ns: i64,
    }
}
/// field_match_type ::= exact | ternary | lpm | range | optional
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldMatch {
    #[prost(uint32, tag="1")]
    pub field_id: u32,
    #[prost(oneof="field_match::FieldMatchType", tags="2, 3, 4, 6, 7, 100")]
    pub field_match_type: ::core::option::Option<field_match::FieldMatchType>,
}
/// Nested message and enum types in `FieldMatch`.
pub mod field_match {
    /// Matches can be performed on arbitrarily-large inputs; the protobuf type
    /// 'bytes' is used to model arbitrarily-large values.
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Exact {
        #[prost(bytes="vec", tag="1")]
        pub value: ::prost::alloc::vec::Vec<u8>,
    }
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Ternary {
        #[prost(bytes="vec", tag="1")]
        pub value: ::prost::alloc::vec::Vec<u8>,
        #[prost(bytes="vec", tag="2")]
        pub mask: ::prost::alloc::vec::Vec<u8>,
    }
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Lpm {
        #[prost(bytes="vec", tag="1")]
        pub value: ::prost::alloc::vec::Vec<u8>,
        /// in bits
        #[prost(int32, tag="2")]
        pub prefix_len: i32,
    }
    /// A Range is logically a set that contains all values numerically between
    /// 'low' and 'high' inclusively.
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Range {
        #[prost(bytes="vec", tag="1")]
        pub low: ::prost::alloc::vec::Vec<u8>,
        #[prost(bytes="vec", tag="2")]
        pub high: ::prost::alloc::vec::Vec<u8>,
    }
    /// If the Optional match should be a wildcard, the FieldMatch must be omitted.
    /// Otherwise, this behaves like an exact match.
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Optional {
        #[prost(bytes="vec", tag="1")]
        pub value: ::prost::alloc::vec::Vec<u8>,
    }
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum FieldMatchType {
        #[prost(message, tag="2")]
        Exact(Exact),
        #[prost(message, tag="3")]
        Ternary(Ternary),
        #[prost(message, tag="4")]
        Lpm(Lpm),
        #[prost(message, tag="6")]
        Range(Range),
        #[prost(message, tag="7")]
        Optional(Optional),
        /// Architecture-specific match value; it corresponds to the other_match_type
        /// in the P4Info MatchField message.
        #[prost(message, tag="100")]
        Other(::pbjson_types::Any),
    }
}
/// table_actions ::= action_specification | action_profile_specification
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableAction {
    #[prost(oneof="table_action::Type", tags="1, 2, 3, 4")]
    pub r#type: ::core::option::Option<table_action::Type>,
}
/// Nested message and enum types in `TableAction`.
pub mod table_action {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Type {
        #[prost(message, tag="1")]
        Action(super::Action),
        #[prost(uint32, tag="2")]
        ActionProfileMemberId(u32),
        #[prost(uint32, tag="3")]
        ActionProfileGroupId(u32),
        #[prost(message, tag="4")]
        ActionProfileActionSet(super::ActionProfileActionSet),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Action {
    #[prost(uint32, tag="1")]
    pub action_id: u32,
    #[prost(message, repeated, tag="4")]
    pub params: ::prost::alloc::vec::Vec<action::Param>,
}
/// Nested message and enum types in `Action`.
pub mod action {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Param {
        #[prost(uint32, tag="2")]
        pub param_id: u32,
        #[prost(bytes="vec", tag="3")]
        pub value: ::prost::alloc::vec::Vec<u8>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionProfileActionSet {
    #[prost(message, repeated, tag="1")]
    pub action_profile_actions: ::prost::alloc::vec::Vec<ActionProfileAction>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionProfileAction {
    #[prost(message, optional, tag="1")]
    pub action: ::core::option::Option<Action>,
    #[prost(int32, tag="2")]
    pub weight: i32,
    #[prost(oneof="action_profile_action::WatchKind", tags="3, 4")]
    pub watch_kind: ::core::option::Option<action_profile_action::WatchKind>,
}
/// Nested message and enum types in `ActionProfileAction`.
pub mod action_profile_action {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum WatchKind {
        /// Using int32 as ports is deprecated, use watch_port instead.
        #[prost(int32, tag="3")]
        Watch(i32),
        #[prost(bytes, tag="4")]
        WatchPort(::prost::alloc::vec::Vec<u8>),
    }
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionProfileMember {
    #[prost(uint32, tag="1")]
    pub action_profile_id: u32,
    #[prost(uint32, tag="2")]
    pub member_id: u32,
    #[prost(message, optional, tag="3")]
    pub action: ::core::option::Option<Action>,
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionProfileGroup {
    #[prost(uint32, tag="1")]
    pub action_profile_id: u32,
    #[prost(uint32, tag="2")]
    pub group_id: u32,
    #[prost(message, repeated, tag="3")]
    pub members: ::prost::alloc::vec::Vec<action_profile_group::Member>,
    /// Max number of weighted member entries in this group. It cannot be modified
    /// after a group has been created. It must not exceed the static
    /// max_group_size included in P4Info. If the max size is not known at group
    /// creation-time, the client may leave this field unset (default value 0), in
    /// which case the static max_group_size value will be used and the group will
    /// be able to include up to max_group_size weighted member entries.
    #[prost(int32, tag="4")]
    pub max_size: i32,
}
/// Nested message and enum types in `ActionProfileGroup`.
pub mod action_profile_group {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Member {
        #[prost(uint32, tag="1")]
        pub member_id: u32,
        #[prost(int32, tag="2")]
        pub weight: i32,
        #[prost(oneof="member::WatchKind", tags="3, 4")]
        pub watch_kind: ::core::option::Option<member::WatchKind>,
    }
    /// Nested message and enum types in `Member`.
    pub mod member {
        #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
        pub enum WatchKind {
            /// Using int32 as ports is deprecated, use watch_port instead.
            #[prost(int32, tag="3")]
            Watch(i32),
            #[prost(bytes, tag="4")]
            WatchPort(::prost::alloc::vec::Vec<u8>),
        }
    }
}
/// An index as a protobuf message. In proto3, fields cannot be optional and
/// there is no difference between an unset integer field and an integer field
/// set to 0. This is inconvenient for reading from P4 array-like structures,
/// such as indirect counters and meters. We need a way to do a wildcard read on
/// these but we cannot use a default zero index value to do so, as zero is a
/// valid index (first entry in the array). We therefore wrap the index in a
/// message.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Index {
    #[prost(int64, tag="1")]
    pub index: i64,
}
/// ------------------------------------------------------------------------------
/// For WriteRequest, Update.Type must be MODIFY.
/// For ReadRequest, the scope is defined as follows:
/// - All meter cells for all meters if meter_id = 0 (default).
/// - All meter cells for given meter_id if index is unset (default).
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MeterEntry {
    #[prost(uint32, tag="1")]
    pub meter_id: u32,
    #[prost(message, optional, tag="2")]
    pub index: ::core::option::Option<Index>,
    #[prost(message, optional, tag="3")]
    pub config: ::core::option::Option<MeterConfig>,
    /// Added in v1.4.0
    #[prost(message, optional, tag="4")]
    pub counter_data: ::core::option::Option<MeterCounterData>,
}
/// ------------------------------------------------------------------------------
/// For WriteRequest, Update.Type must be MODIFY. INSERT and DELETE on direct
/// meters is not allowed and will return an error. The insertion/deletion
/// should happen as part of INSERT/DELETE on the associated table-entry.
/// For ReadRequest, the scope is defined as follows:
/// - All meter cells for all tables if table_entry.table_id = 0.
/// - All meter cells of a table if table_entry.table_id is present and
///    table_entry.match is empty.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DirectMeterEntry {
    /// The associated table entry. This field is required.
    /// table_entry.action is ignored. Other fields specify the match.
    #[prost(message, optional, tag="1")]
    pub table_entry: ::core::option::Option<TableEntry>,
    #[prost(message, optional, tag="2")]
    pub config: ::core::option::Option<MeterConfig>,
    /// Added in v1.4.0
    #[prost(message, optional, tag="3")]
    pub counter_data: ::core::option::Option<MeterCounterData>,
}
/// Modeled to support both RFC 2698: A Two Rate Three Color Marker (trTCM) and
/// RFC 2697: A Single Rate Three Color Marker (srTCM) based on the `type` of the
/// corresponding MeterSpec.
///
/// The trTCM meters a packet stream and marks its packets based on two rates,
/// Peak Information Rate (PIR) and Committed Information Rate (CIR), and their
/// associated burst sizes to be either green, yellow, or red.  A packet is
/// marked red if it exceeds the PIR.  Otherwise it is marked either yellow or
/// green depending on whether it exceeds or doesn't exceed the CIR. For this
/// meter type, `eburst` must be unset.
///
/// The srTCM meters a packet stream and marks its packets based on one rate,
/// Committed Information Rate (CIR), and its associated burst size as well as an
/// Excess Burst Size (EBS) to be either green, yellow, or red. Roughly, a packet
/// is marked green if it doesn't exceed the CIR.  Otherwise it is marked either
/// yellow or green depending on whether it exceeds or doesn't exceed the EBS.
/// For this meter type, it must be the case that `cir == pir && cburst ==
/// pburst`.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MeterConfig {
    /// Committed information rate (units per sec)
    #[prost(int64, tag="1")]
    pub cir: i64,
    /// Committed burst size
    #[prost(int64, tag="2")]
    pub cburst: i64,
    /// Peak information rate (units per sec)
    #[prost(int64, tag="3")]
    pub pir: i64,
    /// Peak burst size
    #[prost(int64, tag="4")]
    pub pburst: i64,
    /// Excess burst size (only used by srTCM).
    /// Added in 1.4.0.
    #[prost(int64, tag="5")]
    pub eburst: i64,
}
/// ------------------------------------------------------------------------------
/// For WriteRequest, Update.Type must be MODIFY.
/// For ReadRequest, the scope is defined as follows:
/// - All counter cells for all counters if counter_id = 0 (default).
/// - All counter cells for given counter_id if index is unset (default).
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CounterEntry {
    #[prost(uint32, tag="1")]
    pub counter_id: u32,
    #[prost(message, optional, tag="2")]
    pub index: ::core::option::Option<Index>,
    #[prost(message, optional, tag="3")]
    pub data: ::core::option::Option<CounterData>,
}
/// ------------------------------------------------------------------------------
/// For WriteRequest, Update.Type must be MODIFY. INSERT and DELETE on direct
/// counters is not allowed and will return an error. The insertion/deletion
/// should happen as part of INSERT/DELETE on the associated table-entry.
/// For ReadRequest, the scope is defined as follows:
/// - All counter cells for all tables if table_entry.table_id = 0.
/// - All counter cells of a table if table_entry.table_id is present and
///    table_entry.match is empty.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DirectCounterEntry {
    /// The associated table entry. This field is required.
    /// table_entry.action is ignored. Other fields specify the match.
    #[prost(message, optional, tag="1")]
    pub table_entry: ::core::option::Option<TableEntry>,
    #[prost(message, optional, tag="2")]
    pub data: ::core::option::Option<CounterData>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CounterData {
    #[prost(int64, tag="1")]
    pub byte_count: i64,
    #[prost(int64, tag="2")]
    pub packet_count: i64,
}
/// Added in v1.4.0
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MeterCounterData {
    #[prost(message, optional, tag="1")]
    pub green: ::core::option::Option<CounterData>,
    #[prost(message, optional, tag="2")]
    pub yellow: ::core::option::Option<CounterData>,
    #[prost(message, optional, tag="3")]
    pub red: ::core::option::Option<CounterData>,
}
/// ------------------------------------------------------------------------------
/// Only one instance of a Packet Replication Engine (PRE) is expected in the
/// P4 pipeline. Hence, no instance id is needed to access the PRE.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PacketReplicationEngineEntry {
    #[prost(oneof="packet_replication_engine_entry::Type", tags="1, 2")]
    pub r#type: ::core::option::Option<packet_replication_engine_entry::Type>,
}
/// Nested message and enum types in `PacketReplicationEngineEntry`.
pub mod packet_replication_engine_entry {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Type {
        #[prost(message, tag="1")]
        MulticastGroupEntry(super::MulticastGroupEntry),
        #[prost(message, tag="2")]
        CloneSessionEntry(super::CloneSessionEntry),
    }
}
/// Used for replicas created for cloning and multicasting actions.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Replica {
    #[prost(uint32, tag="2")]
    pub instance: u32,
    #[prost(oneof="replica::PortKind", tags="1, 3")]
    pub port_kind: ::core::option::Option<replica::PortKind>,
}
/// Nested message and enum types in `Replica`.
pub mod replica {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum PortKind {
        /// Using uint32 as ports is deprecated, use port field instead.
        /// Deprecated in v1.4.0
        #[prost(uint32, tag="1")]
        EgressPort(u32),
        /// Added in v1.4.0
        #[prost(bytes, tag="3")]
        Port(::prost::alloc::vec::Vec<u8>),
    }
}
/// The (port, instance) pair must be unique for each replica in a given
/// multicast group entry. A packet may be multicast by setting the
/// multicast_group field of PSA ingress output metadata to multicast_group_id
/// of a programmed multicast group entry. The port and instance fields of each
/// replica's egress input metadata will be set to the respective values
/// programmed in the multicast group entry.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MulticastGroupEntry {
    #[prost(uint32, tag="1")]
    pub multicast_group_id: u32,
    #[prost(message, repeated, tag="2")]
    pub replicas: ::prost::alloc::vec::Vec<Replica>,
    /// Arbitrary metadata from the controller that is opaque to the target.
    /// Added in 1.4.0.
    #[prost(bytes="vec", tag="3")]
    pub metadata: ::prost::alloc::vec::Vec<u8>,
}
/// A packet may be cloned by setting the clone_session_id field of PSA
/// ingress/egress output metadata to session_id of a programmed clone session
/// entry. Multiple clones may be created via a single clone session entry by
/// using the replicas message. The clones may be distinguished in the egress
/// using the instance field. The class_of_service field of the clone's egress
/// input metadata will be set to the respective value programmed in the clone
/// session entry. Note that in case of multiple clones, all clones, defined
/// for a clone session, will get the same class of service. The
/// packet_length_bytes field must be set to a non-zero value if the clone
/// packet(s) should be truncated to the given value (in bytes). The packet
/// length is also common to all clones in the clone session. If the
/// packet_length_bytes field is 0, no truncation on the clone(s) will be
/// performed.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CloneSessionEntry {
    #[prost(uint32, tag="1")]
    pub session_id: u32,
    #[prost(message, repeated, tag="2")]
    pub replicas: ::prost::alloc::vec::Vec<Replica>,
    #[prost(uint32, tag="3")]
    pub class_of_service: u32,
    #[prost(int32, tag="4")]
    pub packet_length_bytes: i32,
}
/// A member in a P4 value set. Each member defines a list of matches, which can
/// have different match types.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ValueSetMember {
    #[prost(message, repeated, tag="1")]
    pub r#match: ::prost::alloc::vec::Vec<FieldMatch>,
}
/// ------------------------------------------------------------------------------
/// For writing and reading matches in a parser value set. A state transition
/// on an empty value set will never be taken. The number of matches must be at
/// most the size of the value set as specified by the size argument of the
/// value_set constructor in the P4 program.
///
/// For Write Requests:
///    - MODIFY will write the given matches in the repeated field to the value
///      set.
///    - INSERT and DELETE are not allowed.
///
/// For Read Requests:
///    - All matches for all value-set entries if value_set_id = 0
///    - All matches of the value-set if a valid value_set_id is specified
///    - The 'match' field must never be set in the ReadRequest
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ValueSetEntry {
    #[prost(uint32, tag="1")]
    pub value_set_id: u32,
    #[prost(message, repeated, tag="2")]
    pub members: ::prost::alloc::vec::Vec<ValueSetMember>,
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RegisterEntry {
    #[prost(uint32, tag="1")]
    pub register_id: u32,
    #[prost(message, optional, tag="2")]
    pub index: ::core::option::Option<Index>,
    #[prost(message, optional, tag="3")]
    pub data: ::core::option::Option<P4Data>,
}
/// ------------------------------------------------------------------------------
/// Used to configure the digest extern only, not to stream digests or acks
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DigestEntry {
    #[prost(uint32, tag="1")]
    pub digest_id: u32,
    #[prost(message, optional, tag="2")]
    pub config: ::core::option::Option<digest_entry::Config>,
}
/// Nested message and enum types in `DigestEntry`.
pub mod digest_entry {
    /// a DigestList message is streamed when the following conditions are met:
    ///    - there is at least one digest ready
    ///    - the oldest digest in the list has been waiting for at least
    ///      max_timeout_ns nanoseconds or we have gathered max_list_size digests
    ///      already
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Config {
        /// max timeout for outstanding digest data
        #[prost(int64, tag="1")]
        pub max_timeout_ns: i64,
        /// max size for a digest list
        #[prost(int32, tag="2")]
        pub max_list_size: i32,
        /// timeout for DigestListAck message
        #[prost(int64, tag="3")]
        pub ack_timeout_ns: i64,
    }
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamMessageRequest {
    #[prost(oneof="stream_message_request::Update", tags="1, 2, 3, 4")]
    pub update: ::core::option::Option<stream_message_request::Update>,
}
/// Nested message and enum types in `StreamMessageRequest`.
pub mod stream_message_request {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Update {
        #[prost(message, tag="1")]
        Arbitration(super::MasterArbitrationUpdate),
        #[prost(message, tag="2")]
        Packet(super::PacketOut),
        #[prost(message, tag="3")]
        DigestAck(super::DigestListAck),
        #[prost(message, tag="4")]
        Other(::pbjson_types::Any),
    }
}
/// Packet sent from the controller to the switch.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PacketOut {
    #[prost(bytes="vec", tag="1")]
    pub payload: ::prost::alloc::vec::Vec<u8>,
    /// This will be based on P4 header annotated as
    /// @controller_header("packet_out").
    /// At most one P4 header can have this annotation.
    #[prost(message, repeated, tag="2")]
    pub metadata: ::prost::alloc::vec::Vec<PacketMetadata>,
}
/// Used by the controller to ack a DigestList message. To avoid flooding the
/// controller, the switch must not generate digest notifications for the same
/// data until a DigestListAck message with the same list_id is received or the
/// ack timeout (ack_timeout_ns field in DigestEntry.Config) expires.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DigestListAck {
    #[prost(uint32, tag="1")]
    pub digest_id: u32,
    #[prost(uint64, tag="2")]
    pub list_id: u64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamMessageResponse {
    #[prost(oneof="stream_message_response::Update", tags="1, 2, 3, 4, 5, 6")]
    pub update: ::core::option::Option<stream_message_response::Update>,
}
/// Nested message and enum types in `StreamMessageResponse`.
pub mod stream_message_response {
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Update {
        #[prost(message, tag="1")]
        Arbitration(super::MasterArbitrationUpdate),
        #[prost(message, tag="2")]
        Packet(super::PacketIn),
        #[prost(message, tag="3")]
        Digest(super::DigestList),
        #[prost(message, tag="4")]
        IdleTimeoutNotification(super::IdleTimeoutNotification),
        #[prost(message, tag="5")]
        Other(::pbjson_types::Any),
        /// Used by the server to asynchronously report errors which occur when
        /// processing StreamMessageRequest messages.
        #[prost(message, tag="6")]
        Error(super::StreamError),
    }
}
/// Packet sent from the switch to the controller.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PacketIn {
    #[prost(bytes="vec", tag="1")]
    pub payload: ::prost::alloc::vec::Vec<u8>,
    /// This will be based on P4 header annotated as
    /// @controller_header("packet_in").
    /// At most one P4 header can have this annotation.
    #[prost(message, repeated, tag="2")]
    pub metadata: ::prost::alloc::vec::Vec<PacketMetadata>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DigestList {
    /// identifies the digest extern instance
    #[prost(uint32, tag="1")]
    pub digest_id: u32,
    /// identifies a list of entries, used by receiver to ack
    #[prost(uint64, tag="2")]
    pub list_id: u64,
    /// List of entries: each call to the Digest<T>::pack() method corresponds to
    /// one entry and we can have as little as one entry.
    #[prost(message, repeated, tag="3")]
    pub data: ::prost::alloc::vec::Vec<P4Data>,
    /// Timestamp at which the server generated the message (in nanoseconds since
    /// Epoch)
    #[prost(int64, tag="4")]
    pub timestamp: i64,
}
/// Any metadata associated with Packet-IO (controller Packet-In or Packet-Out)
/// needs to be modeled as P4 headers carrying special annotations
/// @controller_header("packet_out") and @controller_header("packet_in")
/// respectively. There can be at most one header each with these annotations.
/// These special headers are captured in P4Info ControllerPacketMetadata.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PacketMetadata {
    /// This refers to Metadata.id coming from P4Info ControllerPacketMetadata.
    #[prost(uint32, tag="1")]
    pub metadata_id: u32,
    #[prost(bytes="vec", tag="2")]
    pub value: ::prost::alloc::vec::Vec<u8>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MasterArbitrationUpdate {
    #[prost(uint64, tag="1")]
    pub device_id: u64,
    /// The role for which the primary client is being arbitrated. For use-cases
    /// where multiple roles are not needed, the controller can leave this unset,
    /// implying default role and full pipeline access.
    #[prost(message, optional, tag="2")]
    pub role: ::core::option::Option<Role>,
    /// The stream RPC with the highest election_id is the primary. The 'primary'
    /// controller instance populates this with its latest election_id. Switch
    /// populates with the highest election ID it has received from all connected
    /// controllers.
    #[prost(message, optional, tag="3")]
    pub election_id: ::core::option::Option<Uint128>,
    /// Switch populates this with OK for the client that is the primary, and
    /// with an error status for all other connected clients (at every primary
    /// client change). The controller does not populate this field.
    #[prost(message, optional, tag="4")]
    pub status: ::core::option::Option<super::super::google::rpc::Status>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Role {
    /// Uniquely identifies this role.
    /// Deprecated in 1.4.0.
    #[deprecated]
    #[prost(uint64, tag="1")]
    pub id: u64,
    /// Added in 1.4.0.
    #[prost(string, tag="3")]
    pub name: ::prost::alloc::string::String,
    /// Describes the role configuration, i.e. what operations, P4 entities,
    /// behaviors, etc. are in the scope of a given role. If config is not set
    /// (default case), it implies all P4 objects and control behaviors are in
    /// scope, i.e. full pipeline access. The format of this message is
    /// out-of-scope of P4Runtime.
    #[prost(message, optional, tag="2")]
    pub config: ::core::option::Option<::pbjson_types::Any>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IdleTimeoutNotification {
    /// The only fields that are required to be set in each TableEntry are the
    /// "key" fields (table_id, match and priority) along with controller_metadata,
    /// metadata and idle_timeout_ns.
    #[prost(message, repeated, tag="1")]
    pub table_entry: ::prost::alloc::vec::Vec<TableEntry>,
    /// Timestamp at which the server generated the message (in nanoseconds since
    /// Epoch)
    #[prost(int64, tag="2")]
    pub timestamp: i64,
}
/// Used by the server to asynchronously report errors which occur when
/// processing StreamMessageRequest messages.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamError {
    /// gRPC canonical error code (see
    /// <https://developers.google.com/maps-booking/reference/grpc-api/status_codes>)
    #[prost(int32, tag="1")]
    pub canonical_code: i32,
    /// Optional. An explanation of the error.
    #[prost(string, tag="2")]
    pub message: ::prost::alloc::string::String,
    /// Optional. Target and architecture specific space to which this error
    /// belongs.
    /// We encourage using triplet: <target>-<arch>-<vendor>,
    /// e.g."targetX-psa-vendor1" or "targetY-psa-vendor2".
    #[prost(string, tag="3")]
    pub space: ::prost::alloc::string::String,
    /// Optional. Numeric code drawn from target-specific error space above.
    #[prost(int32, tag="4")]
    pub code: i32,
    /// Used by the server to convey additional information about the error. One of
    /// the fields must be set (so that the client can identify which type of
    /// stream message triggered the error), but that field may be set to its
    /// default value.
    #[prost(oneof="stream_error::Details", tags="5, 6, 7")]
    pub details: ::core::option::Option<stream_error::Details>,
}
/// Nested message and enum types in `StreamError`.
pub mod stream_error {
    /// Used by the server to convey additional information about the error. One of
    /// the fields must be set (so that the client can identify which type of
    /// stream message triggered the error), but that field may be set to its
    /// default value.
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Details {
        #[prost(message, tag="5")]
        PacketOut(super::PacketOutError),
        #[prost(message, tag="6")]
        DigestListAck(super::DigestListAckError),
        #[prost(message, tag="7")]
        Other(super::StreamOtherError),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PacketOutError {
    /// Optional. The packet out message that caused the error.
    #[prost(message, optional, tag="1")]
    pub packet_out: ::core::option::Option<PacketOut>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DigestListAckError {
    /// Optional. The digest list acknowledgement message that caused the error.
    #[prost(message, optional, tag="1")]
    pub digest_list_ack: ::core::option::Option<DigestListAck>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamOtherError {
    /// Optional. The architecture-specific stream message that caused the error.
    #[prost(message, optional, tag="1")]
    pub other: ::core::option::Option<::pbjson_types::Any>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Uint128 {
    /// Highest 64 bits of a 128 bit number.
    #[prost(uint64, tag="1")]
    pub high: u64,
    /// Lowest 64 bits of a 128 bit number.
    #[prost(uint64, tag="2")]
    pub low: u64,
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SetForwardingPipelineConfigRequest {
    #[prost(uint64, tag="1")]
    pub device_id: u64,
    /// Deprecated in 1.4.0.
    #[deprecated]
    #[prost(uint64, tag="2")]
    pub role_id: u64,
    /// Added in 1.4.0.
    #[prost(string, tag="6")]
    pub role: ::prost::alloc::string::String,
    #[prost(message, optional, tag="3")]
    pub election_id: ::core::option::Option<Uint128>,
    #[prost(enumeration="set_forwarding_pipeline_config_request::Action", tag="4")]
    pub action: i32,
    #[prost(message, optional, tag="5")]
    pub config: ::core::option::Option<ForwardingPipelineConfig>,
}
/// Nested message and enum types in `SetForwardingPipelineConfigRequest`.
pub mod set_forwarding_pipeline_config_request {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Action {
        Unspecified = 0,
        /// Verify that the target can realize the given config. Do not modify the
        /// forwarding state in the target. Returns error if config is not provided
        /// of if the provided config cannot be realized.
        Verify = 1,
        /// Save the config if the target can realize it. Do not modify the
        /// forwarding state in the target. Any subsequent read/write requests must
        /// refer to fields in the new config. Returns error if config is not
        /// provided of if the provided config cannot be realized.
        VerifyAndSave = 2,
        /// Verify, save and realize the given config. Clear the forwarding state
        /// in the target. Returns error if config is not provided of if the
        /// provided config cannot be realized.
        VerifyAndCommit = 3,
        /// Realize the last saved, but not yet committed, config. Update the
        /// forwarding state in the target by replaying the write requests since the
        /// last config was saved. Config should not be provided for this action
        /// type. Returns an error if no saved config is found or if a config is
        /// provided with this message.
        Commit = 4,
        /// Verify, save and realize the given config, while preserving the
        /// forwarding state in the target. This is an advanced use case to enable
        /// changes to the P4 forwarding pipeline configuration with minimal traffic
        /// loss. P4Runtime does not impose any constraints on the duration of the
        /// traffic loss. The support for this option is not expected to be uniform
        /// across all P4Runtime targets. A target that does not support this option
        /// may return an UNIMPLEMENTED error. For targets that support this option,
        /// an INVALID_ARGUMENT error is returned if no config is provided, or if
        /// the existing forwarding state cannot be preserved for the given config
        /// by the target.
        ReconcileAndCommit = 5,
    }
    impl Action {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Action::Unspecified => "UNSPECIFIED",
                Action::Verify => "VERIFY",
                Action::VerifyAndSave => "VERIFY_AND_SAVE",
                Action::VerifyAndCommit => "VERIFY_AND_COMMIT",
                Action::Commit => "COMMIT",
                Action::ReconcileAndCommit => "RECONCILE_AND_COMMIT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSPECIFIED" => Some(Self::Unspecified),
                "VERIFY" => Some(Self::Verify),
                "VERIFY_AND_SAVE" => Some(Self::VerifyAndSave),
                "VERIFY_AND_COMMIT" => Some(Self::VerifyAndCommit),
                "COMMIT" => Some(Self::Commit),
                "RECONCILE_AND_COMMIT" => Some(Self::ReconcileAndCommit),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SetForwardingPipelineConfigResponse {
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ForwardingPipelineConfig {
    #[prost(message, optional, tag="1")]
    pub p4info: ::core::option::Option<super::config::v1::P4Info>,
    /// Target-specific P4 configuration.
    #[prost(bytes="vec", tag="2")]
    pub p4_device_config: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag="3")]
    pub cookie: ::core::option::Option<forwarding_pipeline_config::Cookie>,
}
/// Nested message and enum types in `ForwardingPipelineConfig`.
pub mod forwarding_pipeline_config {
    /// Metadata (cookie) opaque to the target. A control plane may use this field
    /// to uniquely identify this config. There are no restrictions on how such
    /// value is computed, or where this is stored on the target, as long as it is
    /// returned with a GetForwardingPipelineConfig RPC. When reading the cookie,
    /// we need to distinguish those cases where a cookie is NOT present (e.g. not
    /// set in the SetForwardingPipelineConfigRequest, therefore we wrap the actual
    /// uint64 value in a protobuf message.
    #[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Cookie {
        #[prost(uint64, tag="1")]
        pub cookie: u64,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct GetForwardingPipelineConfigRequest {
    #[prost(uint64, tag="1")]
    pub device_id: u64,
    #[prost(enumeration="get_forwarding_pipeline_config_request::ResponseType", tag="2")]
    pub response_type: i32,
}
/// Nested message and enum types in `GetForwardingPipelineConfigRequest`.
pub mod get_forwarding_pipeline_config_request {
    /// Specifies the fields to populate in the response.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ResponseType {
        /// Default behaviour. Returns a ForwardingPipelineConfig with all fields set
        /// as stored by the target.
        All = 0,
        /// Reply by setting only the cookie field, omitting all other fields.
        CookieOnly = 1,
        /// Reply by setting the p4info and cookie fields.
        P4infoAndCookie = 2,
        /// Reply by setting the p4_device_config and cookie fields.
        DeviceConfigAndCookie = 3,
    }
    impl ResponseType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                ResponseType::All => "ALL",
                ResponseType::CookieOnly => "COOKIE_ONLY",
                ResponseType::P4infoAndCookie => "P4INFO_AND_COOKIE",
                ResponseType::DeviceConfigAndCookie => "DEVICE_CONFIG_AND_COOKIE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "ALL" => Some(Self::All),
                "COOKIE_ONLY" => Some(Self::CookieOnly),
                "P4INFO_AND_COOKIE" => Some(Self::P4infoAndCookie),
                "DEVICE_CONFIG_AND_COOKIE" => Some(Self::DeviceConfigAndCookie),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetForwardingPipelineConfigResponse {
    #[prost(message, optional, tag="1")]
    pub config: ::core::option::Option<ForwardingPipelineConfig>,
}
/// Error message used to report a single P4-entity error for a Write RPC.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Error {
    /// gRPC canonical error code (see
    /// <https://developers.google.com/maps-booking/reference/grpc-api/status_codes>)
    #[prost(int32, tag="1")]
    pub canonical_code: i32,
    /// Detailed error message.
    #[prost(string, tag="2")]
    pub message: ::prost::alloc::string::String,
    /// Target and architecture specific space to which this error belongs.
    /// We encourage using triplet: <target>-<arch>-<vendor>,
    /// e.g."targetX-psa-vendor1" or "targetY-psa-vendor2".
    #[prost(string, tag="3")]
    pub space: ::prost::alloc::string::String,
    /// Numeric code drawn from target-specific error space above.
    #[prost(int32, tag="4")]
    pub code: i32,
    /// Optional: Allows reporting back additional target-specific details on the
    /// error.
    #[prost(message, optional, tag="5")]
    pub details: ::core::option::Option<::pbjson_types::Any>,
}
/// ------------------------------------------------------------------------------
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CapabilitiesRequest {
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CapabilitiesResponse {
    /// The full semantic version string (e.g. "1.1.0-rc.1") corresponding to the
    /// version of the P4Runtime API currently implemented by the server.
    #[prost(string, tag="1")]
    pub p4runtime_api_version: ::prost::alloc::string::String,
}
/// ------------------------------------------------------------------------------
/// Reserved controller-specified SDN port numbers for reference.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum SdnPort {
    Unknown = 0,
    /// SDN ports are numbered starting form 1.
    Min = 1,
    /// 0xfffffeff: The maximum value of an SDN port (physical or logical).
    Max = -257,
    /// Reserved SDN port numbers (0xffffff00 - 0xffffffff)
    /// 0xfffffffa: Recirculate the packet back to ingress
    Recirculate = -6,
    /// 0xfffffffd: Send to CPU
    Cpu = -3,
}
impl SdnPort {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            SdnPort::Unknown => "SDN_PORT_UNKNOWN",
            SdnPort::Min => "SDN_PORT_MIN",
            SdnPort::Max => "SDN_PORT_MAX",
            SdnPort::Recirculate => "SDN_PORT_RECIRCULATE",
            SdnPort::Cpu => "SDN_PORT_CPU",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "SDN_PORT_UNKNOWN" => Some(Self::Unknown),
            "SDN_PORT_MIN" => Some(Self::Min),
            "SDN_PORT_MAX" => Some(Self::Max),
            "SDN_PORT_RECIRCULATE" => Some(Self::Recirculate),
            "SDN_PORT_CPU" => Some(Self::Cpu),
            _ => None,
        }
    }
}
include!("p4.v1.tonic.rs");
// @@protoc_insertion_point(module)
